package instances;


import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

import ai.kartia.SupportAAI;
import ai.kartia.SupportFAI;
import l2s.commons.threading.RunnableImpl;
import l2s.commons.util.Rnd;
import l2s.gameserver.Config;
import l2s.gameserver.ThreadPoolManager;
import l2s.gameserver.ai.CtrlIntention;
import l2s.gameserver.ai.DefaultAI;
import l2s.gameserver.data.xml.holder.SkillHolder;
import l2s.gameserver.listener.actor.OnDeathListener;
import l2s.gameserver.listener.zone.OnZoneEnterLeaveListener;
import l2s.gameserver.model.*;
import l2s.gameserver.model.entity.Reflection;
import l2s.gameserver.model.instances.*;
import l2s.gameserver.network.l2.components.NpcString;
import l2s.gameserver.network.l2.s2c.ExShowScreenMessage;
import l2s.gameserver.skills.AbnormalEffect;
import l2s.gameserver.utils.Functions;
import l2s.gameserver.utils.Location;
import l2s.gameserver.utils.PositionUtils;

//By Evil_dnk

public class KartiaSolo95 extends Reflection
{
	private static final int SSQ_CAMERA = 18830;
	private static final int ALTART = 19252;
	private static final int MOBTYPE1 = 19226;
	private static final int MOBTYPE2 = 19227;
	private static final int RULER = 19255;
	private static final int KEEPER = 19228;
	private static final int CAPTIVATED = 33645;
	private static final int SUPPORTTROOPS = 33646;

	private static final int ADOLF_NPC = 33630;
	private static final int ADOLF = 33631;
	private static final int BARTON_NPC = 33632;
	private static final int BARTON = 33633;
	private static final int HAYUK_NPC = 33634;
	private static final int HAYUK = 33635;
	private static final int ELIAH_NPC = 33636;
	private static final int ELIAH = 33637;
	private static final int ELISE_NPC = 33638;
	private static final int ELISE = 33639;
	private static final int ELIAH_SPIRIT = 33640;

	private static final int SOLO_ROOM_DOOR = 16170002;
	private static final int SOLO_RAID_DOOR = 16170003;
	private static final Location SOLO_ENTRANCE = new Location(-108983, -10446, -11920);
	private static final Location SOLO_ZONE_TELEPORTER = new Location(-110264, -10456, -11949);

	private static final List<Location> SOLO_LEFT_KILLER_ROUTES = new ArrayList<Location>();
	private static final List<Location> SOLO_RIGHT_KILLER_ROUTES = new ArrayList<Location>();

	static
	{
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-111256, -10456, -11711));
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-110440, -10472, -11926));
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-110085, -10876, -11920));
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-109182, -10791, -11920));
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-109162, -10453, -11926));
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-109933, -10451, -11688));
		SOLO_LEFT_KILLER_ROUTES.add(new Location(-109933, -10451, -11688));

		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-111256, -10456, -11711));
		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-110440, -10472, -11926));
		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-110020, -9980, -11920));
		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-109157, -10009, -11920));
		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-109162, -10453, -11926));
		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-109933, -10451, -11688));
		SOLO_RIGHT_KILLER_ROUTES.add(new Location(-109933, -10451, -11688));

	}

	private List<NpcInstance> _captivateds = new ArrayList<NpcInstance>();
	private List<NpcInstance> _followers = new ArrayList<NpcInstance>();


	private DeathListener _deathListener = new DeathListener();

	private NpcInstance _kartiaAlthar = null;
	private NpcInstance _ssqCameraLight = null;
	private NpcInstance _ssqCameraZone = null;
	private NpcInstance _ruler = null;
	private NpcInstance _warrior = null;
	private NpcInstance _archer = null;
	private NpcInstance _summoner = null;
	private NpcInstance _healer = null;
	private NpcInstance _knight = null;


	private int _status = 0;

	private ZoneListener _startZoneListener = new ZoneListener();

	private int _savedCaptivateds = 0;
	private String _excludedSupport;
	private boolean _poisonZoneEnabled = false;

	private ScheduledFuture<?> _healTask;
	private ScheduledFuture<?> _supportTask;
	private ScheduledFuture<?> _aggroCheckTask;
	private ScheduledFuture<?> _waveMovementTask;
	private ScheduledFuture<?> _altharCheckTask;
	private ScheduledFuture<?> __poisonZone;

	private static final String STAGE_1 = "K95S_wave1";
	private static final String STAGE_2 = "K95S_wave2";
	private static final String STAGE_3 = "K95S_wave3_part1";
	private static final String STAGE_4 = "K95S_wave3_part2";
	private static final String STAGE_5 = "K95S_wave4_part1";
	private static final String STAGE_6 = "K95S_wave4_part2";
	private static final String STAGE_7 = "K95S_wave5_part1";
	private static final String STAGE_8 = "K95S_wave5_part2";
	private static final String STAGE_9 = "K95S_wave5_part3";
	private static final String STAGE_10 = "K95S_wave6_part1";
	private static final String STAGE_11 = "K95S_wave6_part2";
	private static final String STAGE_12 = "K95S_wave6_part3";
	private static final String STAGE_13 = "K95S_wave7_part1";
	private static final String STAGE_14 = "K95S_wave7_part2";
	private static final String STAGE_15 = "K95S_wave7_part3";
	private static final String STAGE_16 = "K95S_wave_room";
	private static final String STAGE_17 = "K95S_rb1";
	private static final String STAGE_18 = "K95S_rb2";
	private static final String STAGE_19 = "K95S_rb3";
	private static final String STAGE_20 = "K95S_rb4";
	private static final String STAGE_21 = "K95S_rb5";
	private static final String STAGE_22 = "K95S_rb6";
	private static final String STAGE_23 = "K95S_rb7";

	private long wavelastspawntime;

	private int[] mobsIds = {
			//95
			MOBTYPE1,
			MOBTYPE2,
			KEEPER,
			RULER
	};

	private int stage = 0;

	@Override
	protected void onCreate()
	{
		super.onCreate();

		getZone("[400061]").addListener(_startZoneListener);
		getZone("[400062]").addListener(_startZoneListener);
		getZone("[4600072]").addListener(_startZoneListener);
		spawnByGroup("K95S_support");
		getZone("[kartia_teleport_solo]").addListener(_startZoneListener);
		for(NpcInstance npc : getNpcs())
			npc.setRandomWalk(false);
	}

	private class SpawnStage extends RunnableImpl {
		private String stage;

		public SpawnStage(String stage) {
			this.stage = stage;
			wavelastspawntime = System.currentTimeMillis();
		}

		@Override
		public void runImpl() throws Exception {
			spawnByGroup(stage);
			invokeDeathListener();
		}
	}
	public void nextStage()
	{
		stageStart(stage + 1);
		for(Player player : getPlayers())
			currentLevel(player);

	}
	public void currentLevel(Player player)
	{
		if((stage > 1 && stage < 4))
			player.sendPacket(new ExShowScreenMessage(NpcString.STAGE_S1, 3000, ExShowScreenMessage.ScreenMessageAlign.TOP_CENTER, String.valueOf(stage)));
		else if(stage == 5)
			player.sendPacket(new ExShowScreenMessage(NpcString.STAGE_S1, 3000, ExShowScreenMessage.ScreenMessageAlign.TOP_CENTER, String.valueOf(3)));
		else if(stage == 7)
			player.sendPacket(new ExShowScreenMessage(NpcString.STAGE_S1, 3000, ExShowScreenMessage.ScreenMessageAlign.TOP_CENTER, String.valueOf(4)));
		else if(stage == 10)
			player.sendPacket(new ExShowScreenMessage(NpcString.STAGE_S1, 3000, ExShowScreenMessage.ScreenMessageAlign.TOP_CENTER, String.valueOf(5)));
		else if(stage == 13)
			player.sendPacket(new ExShowScreenMessage(NpcString.STAGE_S1, 3000, ExShowScreenMessage.ScreenMessageAlign.TOP_CENTER, String.valueOf(6)));
		else if (stage > 16)
			player.sendPacket(new ExShowScreenMessage(NpcString.STAGE_S1, 3000, ExShowScreenMessage.ScreenMessageAlign.TOP_CENTER, String.valueOf(stage - 16)));
	}
	public int getStage()
	{
		return stage;
	}

	public void stageStart(int nStage)
	{
		stage = nStage;

		switch (nStage){
			case 1: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_1), 3000);
				break;
			case 2: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_2), 1000);
				break;
			case 3: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_3), 1000);
				break;
			case 4: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_4), 1000);
				break;
			case 5: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_5), 1000);
				break;
			case 6: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_6), 1000);
				break;
			case 7: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_7), 1000);
				break;
			case 8: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_8), 1000);
				break;
			case 9: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_9), 1000);
				break;
			case 10: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_10), 1000);
				break;
			case 11: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_11), 1000);
				break;
			case 12: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_12), 1000);
				break;
			case 13: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_13), 1000);
				break;
			case 14: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_14), 1000);
				break;
			case 15: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_15), 1000);
				break;
			case 16: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_16), 1000);
				break;
			case 17: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_17), 1000);
				break;
			case 18: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_18), 1000);
				break;
			case 19: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_19), 1000);
				break;
			case 20: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_20), 1000);
				break;
			case 21: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_21), 1000);
				break;
			case 22: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_22), 1000);
				break;
			case 23: ThreadPoolManager.getInstance().schedule(new SpawnStage(STAGE_23), 1000);
				break;
		}
	}

	private void invokeDeathListener() {
		for (int mobid : mobsIds)
			for (NpcInstance mob : getAllByNpcId(mobid, true))
				mob.addListener(_deathListener);
	}

	private void deleteNpcses(int id)
	{
		for (NpcInstance mob : getAllByNpcId(id, true))
			mob.deleteMe();
	}
	private void startState1()
	{
		getDoor(SOLO_ROOM_DOOR).openMe();
		_poisonZoneEnabled = false;
		_ssqCameraZone.setNpcState(3);
		_ssqCameraZone.setNpcState(0);
		_status = 1;
		saveCaptivateds();
		nextStage();
		Functions.npcSay(getAllByNpcId(KEEPER, false).get(0), NpcString.HOW_ITS_IMPOSSIBLE_RETURNING_TO_ABYSS_AGAIN);
	}

	private void startState2()
	{
		_status = 2;
		getDoor(SOLO_RAID_DOOR).openMe();
		ThreadPoolManager.getInstance().schedule(new RunnableImpl()
		{
			@Override
			public void runImpl()
			{
				deleteNpcses(MOBTYPE1);
				deleteNpcses(MOBTYPE2);
				nextStage();
			}
		},20000L);

		_ruler = addSpawnWithoutRespawn(RULER, new Location(-111296, -15872, -11400, 15596), 0);
		_ruler.setIsInvul(true);
		_ruler.startAbnormalEffect(AbnormalEffect.FLESH_STONE);
		_ruler.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, _ruler);
		_ruler.startParalyzed();


		ThreadPoolManager.getInstance().schedule(new RunnableImpl()
		{
			@Override
			public void runImpl()
			{
				getDoor(SOLO_RAID_DOOR).closeMe();
				if(_savedCaptivateds > 0)
				{
					for(int i = 0; i < _savedCaptivateds; i++)
					{
						NpcInstance support;

						support = addSpawnWithoutRespawn(SUPPORTTROOPS, new Location(-110936 + Rnd.get(100, 250), -14472 + Rnd.get(100, 250), -11452, 47595), 0);
						support.setBusy(true);
						support.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
						_followers.add(support);
					}
				}
			}
		}, 15000L);

		spawnByGroup("K95S_wave_ending");

	}
	public void deselectSupport(String support)
	{
		if(_excludedSupport == null || _excludedSupport.equals(""))
		{
			_excludedSupport = support;
			for(Player player : getPlayers())
				player.teleToLocation(SOLO_ENTRANCE);
		}
		startChallenge();
		_excludedSupport = "";
	}
	
	private class DeathListener implements OnDeathListener {
		@Override
		public void onDeath(Creature victim, Creature killer) {
			if(_ruler != null && victim == _ruler)
			{
				cleanup();
				clearReflection(5, true);
				setReenterTime(getReuseTime());
				killer.addExpAndSp(970749459L, 235848);
			}
			else if (victim.getNpcId() == KEEPER)
			{
				if(stage == 15)
				{
					deleteNpcses(MOBTYPE1);
					deleteNpcses(MOBTYPE2);
					startState1();
				}
				else if(stage == 16)
				{
					startState2();
				}

			}

			else if (getAllByNpcId(MOBTYPE1,true).isEmpty() && getAllByNpcId(MOBTYPE2,true).isEmpty() &&
				getAllByNpcId(KEEPER,true).isEmpty())
			{
				if (getStage() == 14)
				{
					_ssqCameraLight.setNpcState(1);
					_ssqCameraZone.setNpcState(2);
					_poisonZoneEnabled = true;
					nextStage();
					return;
				}

				 if(getStage() == 22)
				{
					freeRuler();
				}

				 if (getStage() < 22)
					nextStage();
			}

			else
				victim.removeListener(_deathListener);

			if(!victim.isPlayer())
				return;

			boolean exit = true;
			for(Player member : getPlayers())
			{
				if(!member.isDead())
				{
					exit = false;
					break;
				}
			}

			if(exit)
			{
				ThreadPoolManager.getInstance().schedule(() ->
				{
					clearReflection(5, true);
				}, 15000L);
			}
		}
	}

	private void cleanup()
	{
		_ssqCameraZone.setNpcState(3);
		_ssqCameraZone.setNpcState(0);
		_ssqCameraZone.deleteMe();
		if(_aggroCheckTask != null)
			_aggroCheckTask.cancel(true);
		if(_waveMovementTask != null)
			_waveMovementTask.cancel(true);
		if(_altharCheckTask != null)
			_altharCheckTask.cancel(true);
		if(_healTask != null)
			_healTask.cancel(true);
		if(_supportTask != null)
			_supportTask.cancel(true);
		if(__poisonZone != null)
			__poisonZone.cancel(true);
	}
  
	private long getReuseTime()
	{
		Calendar _instanceTime = Calendar.getInstance();

		Calendar currentTime = Calendar.getInstance();
		_instanceTime.set(Calendar.HOUR_OF_DAY, 6);
		_instanceTime.set(Calendar.MINUTE, 30);
		_instanceTime.set(Calendar.SECOND, 0);

		if(_instanceTime.compareTo(currentTime) < 0)
			_instanceTime.add(Calendar.DATE, 1);

		return _instanceTime.getTimeInMillis();
	}

	public class ZoneListener implements OnZoneEnterLeaveListener
	{
		@Override
		public void onZoneEnter(Zone zone, Creature cha)
		{
			if(cha.isPlayer() &&  zone.getName().equalsIgnoreCase("[kartia_teleport_solo]"))
			{
				if(_status == 0)
					cha.teleToLocation(SOLO_ZONE_TELEPORTER, cha.getReflection());
			}
			if(cha.isPlayer() && zone.getName().equalsIgnoreCase("[4600072]"))
				cha.getPlayer().addListener(_deathListener);
			if(_ssqCameraZone != null)
				_ssqCameraZone.setNpcState(0);
		}

		@Override
		public void onZoneLeave(Zone zone, Creature cha)
		{
			if(cha.isPlayer() && zone.getName().equalsIgnoreCase("[4600072]"))
				cha.getPlayer().removeListener(_deathListener);
		}
	}


	public void spawnHealingTree()
	{

		Skill buff = SkillHolder.getInstance().getSkill(15003, 1);
		Skill heal = SkillHolder.getInstance().getSkill(15002, 1);

		if(getPlayers().isEmpty())
			return;

		final Player player = getPlayers().get(0);

		Location loc = player.getLoc();

		final Creature tree = addSpawnWithoutRespawn(19256, new Location(loc.getX(), loc.getY(), loc.getZ(), loc.h), 0);
		tree.setTarget(player);
		tree.doCast(buff, player, true);
		tree.doCast(heal, player, true);

		ThreadPoolManager.getInstance().schedule(new RunnableImpl()
		{
			@Override
			public void runImpl()
			{
				if((tree != null) && (!player.isDead()))
				{
					tree.setTarget(player);

					tree.doCast(SkillHolder.getInstance().getSkill(15002, 1), player, true);

					ThreadPoolManager.getInstance().schedule(this, 10000L);
				}
			}
		}
		, 10000L);

		ThreadPoolManager.getInstance().schedule(new RunnableImpl(){
			@Override
			public void runImpl(){
				if((tree != null) && (!player.isDead())){
					tree.setTarget(player);

					tree.doCast(SkillHolder.getInstance().getSkill(15003, 1), player, true);

					ThreadPoolManager.getInstance().schedule(this, 20000L);
				}
			}
		}
				, 20000L);
	}

	public class KartiaSupportTask extends RunnableImpl
	{

		public KartiaSupportTask()
		{
		}

		@Override
		public void runImpl()
		{
			if (getPlayers().isEmpty())
				return;

			for (NpcInstance follower : _followers)
			{
				List<NpcInstance> around = follower.getAroundNpc(600, 150);
				if(follower.isDead())
					continue;

				if (getPlayers() != null && !getPlayers().isEmpty())
					follower.setFollowTarget(getPlayers().get(0));

				follower.setBusy(true);

				for(AggroList.HateInfo aggro : follower.getAggroList().getPlayableMap().values())
					if((aggro.attacker.isNpc()) || (aggro.attacker.isPlayer()))
						follower.getAggroList().remove(aggro.attacker, true);

				if (around != null && !around.isEmpty())
				{
					for (NpcInstance npc : around)
					{
						if (npc instanceof GuardInstance || npc.isPet() || npc.isSummon() || npc.isPlayer() || npc.isPeaceNpc() || npc.isBusy())
						{
							if (follower.getTarget() == null)
							{
								follower.setSpawnedLoc(follower.getLoc());
								follower.broadcastCharInfoImpl();
								follower.setAI(new SupportFAI(follower));
								if (getPlayers() != null && !getPlayers().isEmpty())
									follower.setFollowTarget(getPlayers().get(0));
							}
						}
						else
						{
							follower.setSpawnedLoc(follower.getLoc());
							follower.broadcastCharInfoImpl();
							follower.setAI(new SupportAAI(follower));
							break;
						}
					}
				}
				else
				{
					follower.setSpawnedLoc(follower.getLoc());
					follower.broadcastCharInfoImpl();
					follower.setAI(new SupportFAI(follower));
				}
			}
		}
	}
	
		public class HealTask extends RunnableImpl
	{
		public HealTask()
		{
			//
		}

		@Override
		public void runImpl()
		{
			if(getPlayers().isEmpty())
				return;

			final Player player = getPlayers().get(0);
			if(_healer != null)
			{
				double percentHp = player.getCurrentHp() / player.getMaxHp();
				if(percentHp <= 0.5D)
				{
					_healer.setTarget(player);
					_healer.doCast(SkillHolder.getInstance().getSkill(14901, 1), player, true);

					boolean needTree = true;
					for(NpcInstance npc : getNpcs())
					{
						if(npc.getNpcId() == 19256)
						{
							needTree = false;
							break;
						}
					}
					if(needTree)
					{
						ThreadPoolManager.getInstance().schedule(new RunnableImpl()
						{
							@Override
							public void runImpl()
							{
								_healer.doCast(SkillHolder.getInstance().getSkill(14905, 1), player, true);

								ThreadPoolManager.getInstance().schedule(new RunnableImpl()
								{
									@Override
									public void runImpl()
									{
										spawnHealingTree();
									}
								}
								, 2000L);
							}
						}
						, 2000L);
					}

				}
				else if(percentHp <= 0.85D)
				{
					_healer.setTarget(player);
					_healer.doCast(SkillHolder.getInstance().getSkill(14899, 1), player, true);
				}
			}
		}
	}

	private void startChallenge()
	{
		_kartiaAlthar = addSpawnWithoutRespawn(ALTART, new Location(-110116, -10453, -11307, 0), 0);
		_ssqCameraLight = addSpawnWithoutRespawn(SSQ_CAMERA, new Location(-110116, -10453, -11307, 0), 0);
		_ssqCameraZone = addSpawnWithoutRespawn(SSQ_CAMERA, new Location(-110339, -10443, -11924, 0), 0);

		_ssqCameraZone.setNpcState(3);
		_ssqCameraZone.setNpcState(0);

		_ssqCameraLight.setNpcState(3);
		_ssqCameraLight.setNpcState(0);

		_kartiaAlthar.setRandomWalk(false);
		_kartiaAlthar.setIsInvul(true);
		_ssqCameraLight.setRandomWalk(false);
		_ssqCameraZone.setRandomWalk(false);
		_knight = addSpawnWithoutRespawn(ADOLF, new Location(SOLO_ENTRANCE.getX(), SOLO_ENTRANCE.getY(), SOLO_ENTRANCE.getZ(), 0), 0);
		_followers.add(_knight);
		if(!_excludedSupport.equals("WARRIOR"))
		{
			_warrior = addSpawnWithoutRespawn(BARTON, new Location(SOLO_ENTRANCE.getX(), SOLO_ENTRANCE.getY(), SOLO_ENTRANCE.getZ(), 0), 0);
			_followers.add(_warrior);
		}

		if(!_excludedSupport.equals("ARCHER"))
		{
			_archer = addSpawnWithoutRespawn(HAYUK, new Location(SOLO_ENTRANCE.getX(), SOLO_ENTRANCE.getY(), SOLO_ENTRANCE.getZ(), 0), 0);
			_followers.add(_archer);
		}

		if(!_excludedSupport.equals("SUMMONER"))
		{
			_summoner = addSpawnWithoutRespawn(ELIAH, new Location(SOLO_ENTRANCE.getX(), SOLO_ENTRANCE.getY(), SOLO_ENTRANCE.getZ(), 0), 0);
			_followers.add(_summoner);

			for(byte i = 0; i < 3; i = (byte)(i + 1))
			{
				NpcInstance light = addSpawnWithoutRespawn(ELIAH_SPIRIT, new Location(_summoner.getX(), _summoner.getY(), _summoner.getZ(), 0), 0);
				_followers.add(light);
			}
		}

		if(!_excludedSupport.equals("HEALER"))
		{
			_healer = addSpawnWithoutRespawn(ELISE, new Location(SOLO_ENTRANCE.getX(), SOLO_ENTRANCE.getY(), SOLO_ENTRANCE.getZ(), 0), 0);
			_followers.add(_healer);

			_healTask = ThreadPoolManager.getInstance().scheduleAtFixedRate(new HealTask(), 2000L, 7000L);
		}

		_supportTask = ThreadPoolManager.getInstance().scheduleAtFixedRate(new KartiaSupportTask(), 2000L, 2000L);

		for(DoorInstance door : getDoors())
			door.closeMe();

		spawnByGroup("K95S_captivated");

		for(NpcInstance npc : getAllByNpcId(CAPTIVATED, true))
		{
			if(npc.getNpcId() == CAPTIVATED )
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				npc.doCast(SkillHolder.getInstance().getSkill(14988, 1), npc, true);
				_captivateds.add(npc);
			}
			npc.setBusy(true);
		}


		_aggroCheckTask = ThreadPoolManager.getInstance().scheduleAtFixedRate(new MonsterAggroTask(), 5000L, 4000L);
		_waveMovementTask = ThreadPoolManager.getInstance().scheduleAtFixedRate(new MonsterMovementTask(), 5000L, 6000L);
		_altharCheckTask = ThreadPoolManager.getInstance().scheduleAtFixedRate(new AltharTask(), 5000L, 3000L);
		__poisonZone = ThreadPoolManager.getInstance().scheduleAtFixedRate(new PoisenTask(), 2000L, 10000L);
		stageStart(Config.KARTIA95S_START_WAVE);
	}

	public synchronized void saveCaptivateds()
	{

		for(final NpcInstance captivated : _captivateds)
		{
			_savedCaptivateds += 1;

			ThreadPoolManager.getInstance().schedule(new RunnableImpl()
			{
				@Override
				public void runImpl()
				{

					captivated.deleteMe();
				}
			}
			, 5000);

		}
		_captivateds.clear();
	}

	public void freeRuler() //Выпустить Кракена :)
	{
		if(_ruler != null)
		{
			_ruler.stopAbnormalEffect(AbnormalEffect.FLESH_STONE);
			_ruler.setIsInvul(false);
			_ruler.stopParalyzed();
			_ruler.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK);
		}
	}

	public class AltharTask extends RunnableImpl
	{
		private final Skill HP_ABSORBTION95 = SkillHolder.getInstance().getSkill(14984, 1);

		public AltharTask()
		{
			//
		}

		@Override
		public void runImpl()
		{
			Skill castSkill = HP_ABSORBTION95;

			if(castSkill == null)
				return;

			if(_captivateds != null && !_captivateds.isEmpty())
			{
				for(NpcInstance npc : getNpcs())
				{
					if(!npc.isDead() && npc.getNpcId() != CAPTIVATED && npc instanceof MonsterInstance)
					{
						double distance = PositionUtils.calculateDistance(npc, _kartiaAlthar, true);
						if(distance < 500.0D && npc.getZ() - _kartiaAlthar.getZ() < 150)
						{
							if(npc != null && !npc.isDead())
								npc.doDie(npc);
							_kartiaAlthar.setNpcState(1);
							if(_captivateds.size() > 0)
							{
								final NpcInstance captivated = _captivateds.get(Rnd.get(_captivateds.size()));
								if(captivated != null)
								{
									_kartiaAlthar.setTarget(captivated);
									_kartiaAlthar.doCast(castSkill, captivated, true);
									_kartiaAlthar.setHeading(0);

									ThreadPoolManager.getInstance().schedule(() ->
									{
										captivated.deleteMe();
											if(_captivateds != null)
												_captivateds.remove(captivated);
									}, 11000L);
								}
							}
						}
					}
				}
			}
		}
	}

	public class PoisenTask extends RunnableImpl
	{

		private final Skill ZONE_POISEN95 = SkillHolder.getInstance().getSkill(14991, 1);

		public PoisenTask()
		{
			//
		}

		private void chekZone()
		{


			if (_poisonZoneEnabled)
			{
				for(Player player : getPlayers())
					_ssqCameraZone.doCast(ZONE_POISEN95, player, true);
			}
		}

		@Override
		public void runImpl()
		{
			if (_status == 0)
			{
				chekZone();
			}
		}

	}

			public class MonsterAggroTask extends RunnableImpl
	{

		public MonsterAggroTask()
		{
			//

		}

		@Override
		public void runImpl()
		{
			if(_status <= 2)
			{
				for(NpcInstance npc : getNpcs())
				{
					if (npc.getNpcId() == MOBTYPE1 || npc.getNpcId() == MOBTYPE2 || npc.getNpcId() == KEEPER)
					{
						if (npc.getNpcId() == KEEPER && _status == 1)
						{
							Location loc = new Location(-111288, -13944, -11453);
							double distance = PositionUtils.calculateDistance(npc.getX(), npc.getY(), npc.getZ(), loc.getX(), loc.getY(), loc.getZ(), true);
							if (distance < 100 && npc.getCurrentHpPercents() < 20)
								npc.doDie(npc);
							else if (npc.getCurrentHpPercents() < 20)
							{
								npc.setRunning();
								DefaultAI ai = (DefaultAI) npc.getAI();
								ai.addTaskMove(Location.findPointToStay(-111288, -13944, -11453, 40, 40, npc.getGeoIndex()), true);
								Functions.npcSay(getAllByNpcId(KEEPER, false).get(0), NpcString.YOU_VERY_STRONG_FOR_MORTAL_I_RETREAT);
								return;
							}
						}
					}
				}
			}
		}
	}

	public class MonsterMovementTask extends RunnableImpl
	{
		public MonsterMovementTask()
		{
			//
		}

		@Override
		public void runImpl()
		{
			int counter = 0;
			for (NpcInstance npc : getNpcs())
			{
				if (npc.getNpcId() == MOBTYPE1 || npc.getNpcId() == MOBTYPE2 || npc.getNpcId() == KEEPER)
				{
					if (_status == 0)
					{
						counter++;
						if (!npc.isMoving && npc.getAI().getIntention() != CtrlIntention.AI_INTENTION_CAST && npc.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK)
						{
							List<Location> routes;
							if (counter <= getAllByNpcId(MOBTYPE1, true).size() / 2)
								routes = SOLO_LEFT_KILLER_ROUTES;
							else
								routes = SOLO_RIGHT_KILLER_ROUTES;
							boolean takeNextRoute = false;
							Location nearestLoc = null;
							Double nearestLocDistance = null;
							Location npcLoc = npc.getLoc();
							for (Location loc : routes)
							{
								if (takeNextRoute)
								{
									nearestLoc = loc;
									break;
								}
								double distance = PositionUtils.calculateDistance(npcLoc.getX(), npcLoc.getY(), npcLoc.getZ(), loc.getX(), loc.getY(), loc.getZ(), true);
								if (distance < 150.0D)
									takeNextRoute = true;
								else if (nearestLoc == null)
								{
									nearestLoc = loc;
									nearestLocDistance = Double.valueOf(distance);
								}
								else
								{
									double currentLocDistance = PositionUtils.calculateDistance(npcLoc.getX(), npcLoc.getY(), npcLoc.getZ(), loc.getX(), loc.getY(), loc.getZ(), true);
									if (currentLocDistance <= nearestLocDistance.doubleValue())
									{
										nearestLoc = loc;
										nearestLocDistance = Double.valueOf(currentLocDistance);
									}
								}
							}
							if (nearestLoc != null)
							{
								nearestLoc.setX(nearestLoc.getX());
								nearestLoc.setY(nearestLoc.getY());
								npc.setRunning();
								DefaultAI ai = (DefaultAI) npc.getAI();
								if (System.currentTimeMillis() < wavelastspawntime + 10000L)
									ai.addTaskMove(Location.findPointToStay(-111256, -10456, -11711, 40, 40, npc.getGeoIndex()), true);
								else
								{
									ai.addTaskMove(Location.findPointToStay(nearestLoc, 40, 40, npc.getGeoIndex()), true);
								}
							}
						}
					}
					if (_status == 1)
					{
						if (npc.getNpcId() == KEEPER && npc.getCurrentHpPercents() < 20)
						{
							npc.setRunning();
							DefaultAI ai = (DefaultAI) npc.getAI();
							ai.addTaskMove(Location.findPointToStay(-111288, -13944, -11454, 40, 40, npc.getGeoIndex()), true);
						}
					}
					if (_status == 2 && stage >= 17)
					{
						if (npc.getNpcId() == MOBTYPE1 || npc.getNpcId() == MOBTYPE2 || npc.getNpcId() == KEEPER)
						{
							if (npc.getAggroList().isEmpty() && System.currentTimeMillis() < wavelastspawntime + 10000L)
							{
								npc.setRunning();
								DefaultAI ai = (DefaultAI) npc.getAI();
								ai.addTaskMove(Location.findPointToStay(-111304, -15112, -11452, 100, 200, npc.getGeoIndex()), true);
							}
						}
					}
				}
			}
		}
	}

	@Override
	protected void onCollapse()
	{
		super.onCollapse();
		cleanup();
	}

	public int getStatus()
	{
		return _status;
	}

}